﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class RegistrantEmisImporter
    {
        public void GetEmisInfoForRegistrant(string edipi, string ssn, IRegistrantManager registrantManager)
        {
            REGISTRANT registrant = RegistrantEmisImporter.InitializeRegistrant(this, edipi, ssn, registrantManager);
            EligibilityInfoImporter eligibilityImporter = new EligibilityInfoImporter();
            var emisClient = new eMISMilitaryInformationSerivcePortTypesClient();
            //Contact eMIS and get the registrant's SeviceEligibilityInfo. Extract information from this going forward
            ICollection<MilitaryServiceEligibility> eligibilityInfo =  eligibilityImporter.GetMilitaryServiceEligibilityInfo(edipi, emisClient);
            try
            {
                //add service episodes to registrant 
                //add pre and post 911 deployment indicators to registrant
                eligibilityImporter.ExtractDataFromServiceEligibilityInstances(eligibilityInfo, registrant);
            }
            catch (ArgumentNullException ex)
            {
                AHOBPRLogger.LogErrorMessage("ArgumentNullException",
                                            this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name,
                                            "ExtractDataFromServiceEligibilityInstances method given null argument: " + ex.ParamName);
            }
            //Registrant should now be updated with all relevant info from militaryeligibility info
            //Update Registrant with Deployment Info
        }
    
        /// <summary>
        /// 
        /// </summary>
        /// <param name="edipi"></param>
        /// <param name="ssn"></param>
        /// <param name="registrantManager"></param>
        /// <returns></returns>
        public static REGISTRANT InitializeRegistrant(RegistrantEmisImporter instance, string edipi,string ssn, IRegistrantManager registrantManager)
        {
            REGISTRANT registrant = registrantManager.GetRegistrantById(edipi, ssn);
            return registrantManager.InitializeRegistrantDBObject(registrant);
        }
    }
}
